/*
 * Decompiled with CFR 0.152.
 */
package com.dannyandson.tinygates.blocks;

import com.dannyandson.tinygates.blocks.Side;
import com.dannyandson.tinygates.setup.Registration;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public abstract class AbstractGateBlockEntity
extends BlockEntity {
    protected int output;

    public abstract ResourceLocation getTexture();

    public AbstractGateBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public int getSignal(Side side) {
        if (side == Side.FRONT) {
            return this.output;
        }
        return 0;
    }

    public int getDirectSignal(Side side) {
        return this.getSignal(side);
    }

    public abstract boolean onNeighborChange(@Nullable BlockPos var1);

    protected void outputChange() {
        this.sync();
        this.f_58857_.m_46672_(this.f_58858_, this.m_58900_().m_60734_());
        Direction dir = this.getDirectionFromSide(Side.FRONT);
        BlockPos neighborPos = this.f_58858_.m_121945_(dir);
        BlockState neighborBlockState = this.f_58857_.m_8055_(neighborPos);
        if (!neighborBlockState.m_60795_()) {
            this.f_58857_.m_46590_(neighborPos, neighborBlockState.m_60734_(), dir.m_122424_());
        }
    }

    public Direction getDirectionFromSide(Side side) {
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61372_);
        Direction hfacing = (Direction)this.m_58900_().m_61143_((Property)Registration.GATE_DIRECTION);
        if (side == Side.FRONT) {
            return hfacing;
        }
        if (side == Side.BACK) {
            return hfacing.m_122424_();
        }
        if (side == Side.BOTTOM) {
            return facing;
        }
        if (side == Side.TOP) {
            return facing.m_122424_();
        }
        switch (facing) {
            case DOWN: {
                if (side == Side.RIGHT) {
                    return hfacing.m_122427_();
                }
                return hfacing.m_122428_();
            }
            case UP: {
                if (side == Side.LEFT) {
                    return hfacing.m_122427_();
                }
                return hfacing.m_122428_();
            }
            case NORTH: {
                if (side == Side.LEFT) {
                    return hfacing.m_175364_(Direction.Axis.Z);
                }
                return hfacing.m_175362_(Direction.Axis.Z);
            }
            case SOUTH: {
                if (side == Side.LEFT) {
                    return hfacing.m_175362_(Direction.Axis.Z);
                }
                return hfacing.m_175364_(Direction.Axis.Z);
            }
            case EAST: {
                if (side == Side.LEFT) {
                    return hfacing.m_175362_(Direction.Axis.X);
                }
                return hfacing.m_175364_(Direction.Axis.X);
            }
            case WEST: {
                if (side == Side.LEFT) {
                    return hfacing.m_175364_(Direction.Axis.X);
                }
                return hfacing.m_175362_(Direction.Axis.X);
            }
        }
        return Direction.UP;
    }

    protected void sync() {
        if (!this.f_58857_.f_46443_) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 2);
        }
        this.m_6596_();
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.m_142466_(pkt.m_131708_());
    }

    public CompoundTag m_5995_() {
        CompoundTag nbt = new CompoundTag();
        this.m_183515_(nbt);
        return nbt;
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.output = nbt.m_128451_("output");
    }

    protected void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128405_("output", this.output);
    }
}

